<?php


?>



<h2><?php echo lang('leaves_create_title');?> &nbsp;<?php echo $help;?></h2>



<div class="row-fluid">

    <div class="span8">



<?php echo validation_errors(); ?>



<?php

$attributes = array('id' => 'frmLeaveForm');

echo form_open('leaves/create', $attributes) ?>



    <label for="type">

        <?php echo lang('leaves_create_field_type');?>

        &nbsp;<span class="muted" id="lblCredit"><?php if (!is_null($credit)) { ?>(<?php echo $credit; ?>)<?php } ?></span>

    </label>

    <select class="input-xxlarge" name="type" id="type">

    <?php foreach ($types as $typeId => $TypeName): ?>

        <option value="<?php echo $typeId; ?>" <?php if ($typeId == $defaultType) echo "selected"; ?>><?php echo $TypeName; ?></option>

    <?php endforeach ?>

    </select>



    <label for="viz_startdate"><?php echo lang('leaves_create_field_start');?></label>

    <input type="text" name="viz_startdate" id="viz_startdate" value="<?php echo set_value('startdate'); ?>" autocomplete="off" />

    <input type="hidden" name="startdate" id="startdate" />

    <select name="startdatetype" id="startdatetype">

        <option value="Morning" selected><?php echo lang('Morning');?></option>

        <option value="Afternoon"><?php echo lang('Afternoon');?></option>

    </select><br />



    <label for="viz_enddate"><?php echo lang('leaves_create_field_end');?></label>

    <input type="text" name="viz_enddate" id="viz_enddate" value="<?php echo set_value('enddate'); ?>" autocomplete="off" />

    <input type="hidden" name="enddate" id="enddate" />

    <select name="enddatetype" id="enddatetype">

        <option value="Morning"><?php echo lang('Morning');?></option>

        <option value="Afternoon" selected><?php echo lang('Afternoon');?></option>

    </select><br />



    <label for="duration"><?php echo lang('leaves_create_field_duration');?> <span id="tooltipDayOff"></span></label>

    <?php if ($this->config->item('disable_edit_leave_duration') == TRUE) { ?>

    <input type="text" name="duration" id="duration" value="<?php echo set_value('duration'); ?>" readonly />

    <?php } else { ?>

    <input type="text" name="duration" id="duration" value="<?php echo set_value('duration'); ?>" />

    <?php } ?>



    <span style="margin-left: 2px;position: relative;top: -5px;" id="spnDayType"></span>



    <div class="alert hide alert-error" id="lblCreditAlert" onclick="$('#lblCreditAlert').hide();">

        <button type="button" class="close">&times;</button>

        <?php echo lang('leaves_create_field_duration_message');?>

    </div>



    <div class="alert hide alert-error" id="lblOverlappingAlert" onclick="$('#lblOverlappingAlert').hide();">

        <button type="button" class="close">&times;</button>

        <?php echo lang('leaves_create_field_overlapping_message');?>

    </div>



    <div class="alert hide alert-error" id="lblOverlappingDayOffAlert" onclick="$('#lblOverlappingDayOffAlert').hide();">

        <button type="button" class="close">&times;</button>

        <?php echo lang('leaves_flash_msg_overlap_dayoff');?>

    </div>



    <label for="cause"><?php echo lang('leaves_create_field_cause');?></label>

    <textarea name="cause"><?php echo set_value('cause'); ?></textarea>



    <br/><br/>

    <button name="status" value="1" type="submit" class="btn btn-primary"><i class="fa fa-calendar" aria-hidden="true"></i>&nbsp; <?php echo lang('Planned');?></button>

    &nbsp;&nbsp;

    <button name="status" value="2" type="submit" class="btn btn-primary "><i class="icon-ok icon-white"></i>&nbsp; <?php echo lang('Requested');?></button>

    <br/><br/>

    <a href="<?php echo base_url(); ?>leaves" class="btn btn-danger"><i class="icon-remove icon-white"></i>&nbsp; <?php echo lang('leaves_create_button_cancel');?></a>

</form>



    </div>

</div>



<div class="modal hide" id="frmModalAjaxWait" data-backdrop="static" data-keyboard="false">

    <div class="modal-header">

        <h1><?php echo lang('global_msg_wait');?></h1>

    </div>

    <div class="modal-body">

        <img src="<?php echo base_url();?>assets/images/loading.gif"  align="middle">

    </div>

 </div>



<link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/css/selectize.bootstrap2.css" />

<link rel="stylesheet" href="<?php echo base_url();?>assets/css/flick/jquery-ui.custom.min.css">

<script src="<?php echo base_url();?>assets/js/jquery-ui.custom.min.js"></script>

<?php //Prevent HTTP-404 when localization isn't needed

if ($language_code != 'en') { ?>

<script src="<?php echo base_url();?>assets/js/i18n/jquery.ui.datepicker-<?php echo $language_code;?>.js"></script>

<?php } ?>

<script type="text/javascript" src="<?php echo base_url();?>assets/js/moment-with-locales.min.js" type="text/javascript"></script>

<script src="<?php echo base_url();?>assets/js/bootbox.min.js"></script>

<script type="text/javascript" src="<?php echo base_url();?>assets/js/selectize.min.js"></script>



<?php require_once dirname(BASEPATH) . "/local/triggers/leave_view.php"; ?>

<script>

$(document).on("click", "#showNoneWorkedDay", function(e) {

  showListDayOffHTML();

});

</script>

<script type="text/javascript">

    var baseURL = '<?php echo base_url();?>';

    var userId = <?php echo $user_id; ?>;

    var leaveId = null;

    var languageCode = '<?php echo $language_code;?>';

    var dateJsFormat = '<?php echo lang('global_date_js_format');?>';

    var dateMomentJsFormat = '<?php echo lang('global_date_momentjs_format');?>';



    var noContractMsg = "<?php echo lang('leaves_validate_flash_msg_no_contract');?>";

    var noTwoPeriodsMsg = "<?php echo lang('leaves_validate_flash_msg_overlap_period');?>";



    var overlappingWithDayOff = "<?php echo lang('leaves_flash_msg_overlap_dayoff');?>";

    var listOfDaysOffTitle = "<?php echo lang('leaves_flash_spn_list_days_off');?>";



function validate_form() {

    var fieldname = "";



    //Call custom trigger defined into local/triggers/leave.js

    if (typeof triggerValidateCreateForm == 'function') {

       if (triggerValidateCreateForm() == false) return false;

    }



    if ($('#viz_startdate').val() == "") fieldname = "<?php echo lang('leaves_create_field_start');?>";

    if ($('#viz_enddate').val() == "") fieldname = "<?php echo lang('leaves_create_field_end');?>";

    if ($('#duration').val() == "" || $('#duration').val() == 0) fieldname = "<?php echo lang('leaves_create_field_duration');?>";

    if (fieldname == "") {

        return true;

    } else {

        bootbox.alert(<?php echo lang('leaves_validate_mandatory_js_msg');?>);

        return false;

    }

}



$(function () {

    //Selectize the leave type combo

    $('#type').selectize();

});



<?php if ($this->config->item('csrf_protection') == TRUE) {?>

$(function () {

    $.ajaxSetup({

        data: {

            <?php echo $this->security->get_csrf_token_name();?>: "<?php echo $this->security->get_csrf_hash();?>",

        }

    });

});

<?php }?>

</script>

<script type="text/javascript" src="<?php echo base_url();?>assets/js/lms/leave.edit-0.7.0.js" type="text/javascript"></script>

